<?php
class EBuilderTool {
	private function __construct() {
	}
	
	public static function ArrayElement($array,$element) {
		return ((is_array($array)) ? $array[$element] : $array );
	}
	
	// Recursively flatten multidimensional arrays into a single
	// dimension array.
	// Parameters:
	// $inital_array - Array to be flattened.
	// Returns:
	// Single dimensional array.
	public static function FlattenArray($initial_array) {
		// handle non-array parameters
		if (!is_array($initial_array)) {
			$result_array[]=$intial_array;
			return $result_array;
		}
		// loop through entire array
		reset ($initial_array);
		$result_array=array();
		while (list($key, $val)=each($initial_array)) {
			if (is_array($val)) {
				$sub_array=EBuilderTool::FlattenArray($val);
				$result_array=((is_array($result_array)) ? 
					array_merge($result_array, $sub_array) : $sub_array);
			}
			else { 
				// if scalar
				// Use strlen instead of empty to handle "0"s
				if (!strlen($val)<1) {
					// if it is a non-numeric key...
					if (($key+0)==0) {
						$result_array[$key]=$val;
					}
					else {
						$result_array[]=$val;
					}
				}
			}
		}
				
		// return result array
		asort($result_array);
		return ($result_array);
	}
	
	// Determines if a value is in or equal to a variable
	// Parameters:
	// $haystack - Variable to search in
	// $needle - Variable to search for
	// Returns:
	// Boolean, whether variable is found.
	public static function InThis($var,$val) {
		if (!is_array($var)) {
			// handle as scalar
			if ($var==$val)
				return (true);
		}
		else {
			// handle as array
			reset($var);
			while (list ($k, $v)=each ($var)) {
				if ($v==$val)
					return (true);
			}
		}
		
		return (false);
	}
	
	// Converts email addresses and URLs into links.
	// Parameters:
	// $original - Original string to be translated.
	// Returns:
	// Linked text.
	public static function Linkify($original) {
		$s=$original;
		
		// Linkify mail addresses
		$mylink=preg_replace("/\ ([-^!#$%&'*+\/=?`{|}~.\w]+@([-a-zA-Z0-9.]+\.)[-a-z
										A-Z0-9]{2,6})/", ' <a href="mailto:\\1">\\1</a>', $s);
		
		// Linkify web addresses
		$mylink=preg_replace("/\s([a-z]*\:\/\/[A-Za-z0-9\.\/\?\&\~\%]*)\s/i", ' <a
										href="\\1">\\1</a> ', $s);
		
		return ($mylink);
	}
	
	// Prepares a string (possibly with slashes) to be displayed in
	// an HTML context.
	// Parameters:
	// $string - String to be displayed
	// $force_conversion - (optional) Do we force conversion of
	// embedded HTML tags? Defaults to false.
	// Returns:
	// HTML safe string
	public static function Prepare($string,$force_conversion=false) {
		return ((!$force_conversion && 
			(eregi('<[A-Z/]*>', $string) || eregi('&quot;', $string)) )
			? stripslashes($string) :	htmlentities(stripslashes($string)));
	}
	
	public static function WebLink($text, $link='') {
		if ($link=='')
			$link=$text;
			
			return ("<a href=\"$link\" "."onMouseOver=\"window.status=\".
							$text.; return true;\".onMouseOut=\"window.status=;
							return true;\">$text</a>");
	}
	
	public static function CheckSuhosinPatchMethodOne() {
		ob_start();
		phpinfo();
		$phpinfo = ob_get_contents();
		ob_end_clean();
		// has been found 'Suhosin' string
		if (strpos($phpinfo, 'Suhosin') !== FALSE)
			return (true);
		// has not been found 'Suhosin' string
		else
			return (false);
	}
	
	public static function CheckSuhosinPatchMethodTwo() {
		if (!extension_loaded('suhosin')) {
			if (!dl('suhosin.so')) {
        // extension not loaded
        return (false);
			}
		}
		// extension loaded
		return (true);
	}
	
	public static function CheckSuhosinPatchMethodThree() {
		// get length of 'suhosin.session.max_id_length' string
		// if it is not en empty string then Suhosin is installed
		return
			($isSuhosinInstalled = ini_get('suhosin.session.max_id_length') !== '');
	}
	
	public function GDSupport() {
		/* Displays details of GD support on your server */
		echo '<div style="margin: 10px;">';
		echo '<p style="color: #444444; font-size: 130%;">GD is ';
		if (function_exists("gd_info")) {
			echo '<span style="color: #00AA00; font-weight: bold;">
						supported</span> by your server!</p>';
			$gd = gd_info();      
			foreach ($gd as $k => $v) {
				echo '<div style="width: 340px; border-bottom: 1px
							solid #DDDDDD; padding: 2px;">';
				echo '<span style="float: left;width: 300px;">' . $k . '</span> ';
				if ($v)
					echo '<span style="color: #00AA00; font-weight: bold;">Yes</span>';
				else
					echo '<span style="color: #EE0000; font-weight: bold;">No</span>';
				echo '<div style="clear:both;"><!-- --></div></div>';
			}
		}
		else {
			echo '<span style="color: #EE0000; font-weight: bold;">
				not supported</span> by your server!</p>';
		}
		echo '</div>';		
	}
}
?>