<?php
class DateTool {
	private function __construct() {
  }
  
	private static function DateDiff($begin_date, $end_date='') {
    if (empty($end_date))
      $end_date=date('Y-m-d');
    
    $begin_y=substr($begin_date,0,4)+0;
    $begin_m=substr($begin_date,4,2)+0;
    $begin_d=substr($begin_date,6,2)+0;
    $end_y	=substr($end_date,0,4)+0;
    $end_m	=substr($end_date,4,2)+0;
    $end_d	=substr($end_date,6,2)+0;
    
    if (($begin_y>$end_y) ||
       (($begin_y==$end_y) && ($begin_m>$end_m)) ||
       (($begin_y==$end_y) && ($begin_m==$end_m) && ($begin_d>$end_d))) {
      // switch the dates
      $t_y     = $begin_y; $t_m     = $begin_m; $t_d     = $begin_d;
      $begin_y = $end_y;   $begin_m = $end_m;   $begin_d = $end_d;
      $end_y   = $t_y;     $end_m   = $t_m;     $end_d   = $t_d;
    }
    // end checking if we have to reverse everything
    
    // determine difference in years
    $year_diff=$end_y-$begin_y;
    
    // determine difference in months
    $month_diff=$end_m-$begin_m;
    
    // perform roll overs for year
    if ($month_diff<0) {
      $month_diff+=12;
      $year_diff--; // decrement from year
    }
    
    // determine difference in months
    $day_diff=$end_d-$begin_d;
    // perform roll overs for month
    if ($day_diff<0) {
      if (DateTool::IsLeapYear($year_diff))
        $day_diff+=30;
      else
        $day_diff+=29;
      $month_diff--; // decrement from month
    }
    
    // return as a list
    return array($year_diff,$month_diff,$day_diff);
  }
  
	private static function IsLeapYear($year) { 
    # Check for valid parameters # 
    if (!is_int($year) || $year < 0) { 
      printf('Wrong parameter for $year in function isLeapYear. 
							It must be a positive integer.'); 
      exit(); 
    } 
        
    # In the Gregorian calendar there is a 
		# leap year every year divisible by four 
    # except for years which are both divisible
		# by 100 and not divisible by 400. 
    if ($year % 4 != 0) {
      return 28; 
    } 
    else { 
      if ($year % 100 != 0) { 
        # Leap year 
        return 29;
      } 
      else { 
        if ($year % 400 != 0) { 
          return 28; 
        } 
        else { 
          # Leap year 
          return 29;
        } 
      } 
    } 
  }
  
  public static function DateAssemble($datevar,$array_index=-1) {
    global ${$datevar.'_m'}, ${$datevar.'_d'}, ${$datevar.'_y'}, ${$datevar};
    
    $curr_date=strtotime($datevar);
    $y=date('Y',$curr_date);
    $m=date('m',$curr_date);
    $d=date('d',$curr_date);
    
    // Use the whole if they are empty
    if (empty($m) && empty($d) && empty($y))
      return ${$datevar};
      
    // return the composited string
    return $y.'-'.$m.'-'.$d;
  }
  
  public static function DateValues($datevar,$epoch=1900) {
    // move into local vars
    $curr_date=strtotime($datevar);
    $y=date('Y',$curr_date);
    $m=date('m',$curr_date);
    $d=date('d',$curr_date);
    $w=$datevar;
    
    if (!empty($w) && (empty($m) || empty($d) || empty($y))) {
      // if the whole thing is there, split into $m,$d,$y
      $y=substr($w,0,4);
      $m=substr($w,5,2);
      $d=substr($w,8,2);
    }
    else if (empty($y) && empty($m) && empty($d)) {
      $y=date('Y')+0;
      $m=date('m')+0;
      $d=date('d')+0;
    }
    // end if not empty whole data
    
    // set boundaries
		$year_part		='';
		$month_part		='';
		$day_part			='';
    $starting_year=$epoch;
    $ending_year	=date('Y')+20;
    
    // legacy dates check
    if (($y>1800) && ($y<$starting_year))
      $starting_year=$y;
    if (($y>1800) && ($y>$ending_year  ))
      $ending_year=$y;
    
    for ($i=$starting_year;$i<=$ending_year;$i++) {
      $year_part.=$i.';';
    }
    for ($i=1;$i<=12;$i++) {
      $month_part.=(($i<10) ? '0' : '' ).$i.';';
    }
    for ($i=1;$i<=31;$i++) {
      $day_part.=( ($i<10) ? '0' : '' ).$i.';';
    }
    
    return array($year_part,$month_part,$day_part);
  }
  
  public static function DateVars($varname) {
    $curr_date=strtotime($varname);
    $y=date('Y',$curr_date);
    $m=date('m',$curr_date);
    $d=date('d',$curr_date);
    
    // return as a list
    // return array ($varname, $varname.'_m', $varname.'_d', $varname.'_y');
    return array($varname,$y,$m,$d);
  }
  
  public static function DifferenceDisplay($begin_date, $end_date='', 
																		$year_text,$month_text, $day_text) {
    // grab the difference			    
    list($y, $m, $d)=DateTool::DateDiff($begin_date,$end_date);
    
    // handle born today
    if (($y==0) && ($m==0) && ($d==0))
      return '0 '.$day_text;
    
    // empty buffer
    $buffer = '';
    
    if ($y >= 0)
      $buffer.=($y+0).' '.$year_text.' ';    
    if ($m >= 0)
      $buffer.=($m+0).' '.$month_text.' ';    
    if ($d >= 0)
      $buffer.=($d+0).' '.$day_text;
    
    return $buffer;
  }
  
  // Gets a new time in seconds
	// and returns hour/minute/second format
	public static function HumanReadableTime($total_time) {
		$h=$m=$s=0;
		
		// catch divide by zero errors
		if ($total_time<=0)
			return '0s';
		
		$m=floor($total_time/60);
		$s=floor($total_time%60);
		if ($m <= 0)
			// drop seconds, if you can
			return $s.'s'; 
		
		$h=floor($m/60);
		$m=floor($m%60);
		if ($h<=0)
			// drop minutes and seconds
			return $m.'m '.$s.'s';
		
		return $h.'h '.$m.'m '.$s.'s';
	}
	
	public static function UnixTimestamp($datevar) {
    $curr_date=strtotime($datevar);
		// check the date string value
		if ($curr_date===false) {
			die ('The string ('.$datevar.') is bogus.');
		}
		// ok our date string is correct
		// we can get the correct
		// unix timestamp value
    $y=date('Y',$curr_date);
    $m=date('m',$curr_date);
    $d=date('d',$curr_date);
    $h=date('H',$curr_date);
    $i=date('i',$curr_date);
    $s=date('s',$curr_date);
    $timestamp=mktime($h, $i, $s, $m, $d, $y);
    
		return $timestamp;
  }
  
  public static function UnixTimestampToDate($currlang,$unix_timestamp) {
		// german style date and time
		if (($currlang=='de') || ($currlang=='deutsch'))
			return (date( 'd.m.Y. H:i:s',$unix_timestamp));
		// hungarian style date and time
		elseif (($currlang=='hu') || ($currlang=='hungarian'))
			return (date( 'Y.m.d. H:i:s',$unix_timestamp));
		// english style date and time
		else
			return (date( 'm.d.Y. h:i:s a.',$unix_timestamp));
	}
}
?>