/**************/
/* bubbleCore */
/**************/
var ToolTipEvents = {
	offsetLeft : (-25),
	offsetTop : (10),
	posRef : function(){
		return (
			(document.documentElement.scrollTop)?
				document.documentElement : document.body
			);
	},
	showTooltip : function(e){
		ToolTipEvents._cleanup();
		BubbleTips.bubbleNode.appendChild(this.tooltip);
		Effects.fadeIn(this.tooltip,BubbleTips.opacity);
		ToolTipEvents.followMouse(e);
	},
	hideTooltip : function(e){
		Effects.fadeOut(this.tooltip, ToolTipEvents._cleanup);
	},
	followMouse : function(e){
		if(e == null){ e = window.event };
		var posx = ToolTipEvents.offsetLeft;
		var posy = ToolTipEvents.offsetTop;
		if(e.pageX || e.pageY){
			posx += e.pageX;
			posy += e.pageY;
		} else if(e.clientX || e.clientY) {
			posx += e.clientX + ToolTipEvents.posRef().scrollLeft;
			posy += e.clientY + ToolTipEvents.posRef().scrollTop;
		}
		BubbleTips.bubbleNode.style.top  = (posy) + "px";
		BubbleTips.bubbleNode.style.left = (posx) + "px";
	},
	_cleanup : function(){
		var bubble = BubbleTips.bubbleNode;
		if( bubble.childNodes.length > 0 ){
			bubble.removeChild(bubble.firstChild);
		}
	}
};

var Effects = {
	fadeIn : function (elem,maxOpac){
		elem.fadeIn = Effects._fadeIn;
		elem.maxOpac = maxOpac;
		elem.curOpac = 0;
		this.cancelCurrent();
		elem.fadeIn();
	},
	fadeOut : function (elem,fadeDoneF){
		elem.fadeOut = Effects._fadeOut;
		elem.fadeOutDone = fadeDoneF;
		this.cancelCurrent();
		elem.fadeOut();
	},
	cancelCurrent : function() {
		clearTimeout(window.evtId);
	},
	_fadeIn : function() {
		if( (+this.curOpac) < (+this.maxOpac) ){
			this.curOpac = (+this.curOpac)+(0.05);
			Effects.setOpacity(this,this.curOpac);
			window.fadeInElem = this;
			window.evtId = setTimeout(function(){this.fadeInElem.fadeIn()},30);
		} else {
			Effects.setOpacity(this,this.maxOpac);
			window.fadeInElem = null;
		}
	},
	_fadeOut : function() {
		if( (+this.curOpac) > 0 ){
			this.curOpac = Math.max(0,(+this.curOpac)-(0.05));
			Effects.setOpacity(this,this.curOpac);
			window.fadeOutElem = this;
			window.evtId = setTimeout(function(){this.fadeOutElem.fadeOut()},30);
		} else if(this.fadeOutDone) {
			this.fadeOutDone();
			window.fadeOutElem = null;
		}
	},
	setOpacity : function (elem,opac){
		elem.style.filter="alpha(opacity:"+ ((+opac)*100) +")";
		elem.style.KHTMLOpacity=opac;
		elem.style.MozOpacity=opac;
		elem.style.opacity=opac;
	}
};

var BubbleTips = {
	opacity : "0.85",
	bubbleNode : null,
	activateTipOn : function(type){
		var bubble = document.createElement("span");
		bubble.style.position = "absolute";
		bubble.style.zIndex = "9";
		this.bubbleNode = bubble;
		document.getElementsByTagName("body")[0].appendChild(bubble);
		var tipTags = document.getElementsByTagName(type);
		for(var i=0;i<tipTags.length;i++){
			this.bindBubbleTip(tipTags[i]);
		}
	},
	bindBubbleTip : function(elem) {
		var tipText=elem.getAttribute("title");
		if(tipText==null || tipText.length==0){
			tipText="No title attribute, how sad :-(";
		}
		elem.removeAttribute("title");
		var bubble = this.createElem("span","bubbleTooltip");
		var tipTop = this.createElem("span","top");
		tipTop.appendChild(document.createTextNode(tipText));
		bubble.appendChild(tipTop);
		bubble.appendChild(this.createElem("span","bottom"));
		Effects.setOpacity(bubble,this.opacity);
		elem.tooltip = bubble;
		elem.onmouseover = ToolTipEvents.showTooltip;
		elem.onmouseout  = ToolTipEvents.hideTooltip;
		elem.onmousemove = ToolTipEvents.followMouse;
	},
	createElem : function(tag,className){
		var elem = document.createElement(tag);
		elem.className = className;
		elem.style.display = "block";
		return elem;
	}
};

/************/
/* colortip */
/************/
(function($){
	$.fn.colorTip = function(settings){

		var defaultSettings = {
			color		: 'yellow',
			timeout		: 500
		}
		
		var supportedColors = ['red','green','blue','white','yellow','black'];
		
		/* Combining the default settings object with the supplied one */
		settings = $.extend(defaultSettings,settings);

		/*
		*	Looping through all the elements and returning them afterwards.
		*	This will add chainability to the plugin.
		*/
		
		return this.each(function(){

			var elem = $(this);
			
			// If the title attribute is empty, continue with the next element
			if(!elem.attr('title')) return true;
			
			// Creating new eventScheduler and Tip objects for this element.
			// (See the class definition at the bottom).
			
			var scheduleEvent = new eventScheduler();
			var tip = new Tip(elem.attr('title'));

			// Adding the tooltip markup to the element and
			// applying a special class:
			
			elem.append(tip.generate()).addClass('colorTipContainer');

			// Checking to see whether a supported color has been
			// set as a classname on the element.
			
			var hasClass = false;
			for(var i=0;i<supportedColors.length;i++)
			{
				if(elem.hasClass(supportedColors[i])){
					hasClass = true;
					break;
				}
			}
			
			// If it has been set, it will override the default color
			
			if(!hasClass){
				elem.addClass(settings.color);
			}
			
			// On mouseenter, show the tip, on mouseleave set the
			// tip to be hidden in half a second.
			
			elem.hover(function(){

				tip.show();
				
				// If the user moves away and hovers over the tip again,
				// clear the previously set event:
				
				scheduleEvent.clear();

			},function(){

				// Schedule event actualy sets a timeout (as you can
				// see from the class definition below).
				
				scheduleEvent.set(function(){
					tip.hide();
				},settings.timeout);

			});
			
			// Removing the title attribute, so the regular OS titles are
			// not shown along with the tooltips.
			
			elem.removeAttr('title');
		});
		
	}


	/*
	/	Event Scheduler Class Definition
	*/

	function eventScheduler(){}
	
	eventScheduler.prototype = {
		set	: function (func,timeout){

			// The set method takes a function and a time period (ms) as
			// parameters, and sets a timeout

			this.timer = setTimeout(func,timeout);
		},
		clear: function(){
			
			// The clear method clears the timeout
			
			clearTimeout(this.timer);
		}
	}


	/*
	/	Tip Class Definition
	*/

	function Tip(txt){
		this.content = txt;
		this.shown = false;
	}
	
	Tip.prototype = {
		generate: function(){
			
			// The generate method returns either a previously generated element
			// stored in the tip variable, or generates it and saves it in tip for
			// later use, after which returns it.
			
			return this.tip || (this.tip = $('<span class="colorTip">'+this.content+
											 '<span class="pointyTipShadow"></span><span class="pointyTip"></span></span>'));
		},
		show: function(){
			if(this.shown) return;
			
			// Center the tip and start a fadeIn animation
			this.tip.css('margin-left',-this.tip.outerWidth()/2).fadeIn('fast');
			this.shown = true;
		},
		hide: function(){
			this.tip.fadeOut();
			this.shown = false;
		}
	}
	
})(jQuery);